#ifndef __OD2_ERROR_H
#define __OD2_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// Object Dictionary error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_OD2_OBJECT_IN_USE
//
// MessageText:
//
//  Object in use.
//
#define TLR_E_OD2_OBJECT_IN_USE          ((TLR_RESULT)0xC0280001L)

//
// MessageId: TLR_E_OD2_INVALID_SUBINDEX
//
// MessageText:
//
//  Invalid subindex. No such subobject.
//
#define TLR_E_OD2_INVALID_SUBINDEX       ((TLR_RESULT)0xC0280002L)

//
// MessageId: TLR_E_OD2_INVALID_DATATYPE
//
// MessageText:
//
//  Invalid datatype.
//
#define TLR_E_OD2_INVALID_DATATYPE       ((TLR_RESULT)0xC0280003L)

//
// MessageId: TLR_E_OD2_INVALID_BUFFER_PTR
//
// MessageText:
//
//  Invalid buffer pointer.
//
#define TLR_E_OD2_INVALID_BUFFER_PTR     ((TLR_RESULT)0xC0280004L)

//
// MessageId: TLR_E_OD2_INVALID_SECTOR
//
// MessageText:
//
//  Invalid sector.
//
#define TLR_E_OD2_INVALID_SECTOR         ((TLR_RESULT)0xC0280005L)

//
// MessageId: TLR_E_OD2_INVALID_SUBSECTOR
//
// MessageText:
//
//  Invalid subsector.
//
#define TLR_E_OD2_INVALID_SUBSECTOR      ((TLR_RESULT)0xC0280006L)

//
// MessageId: TLR_E_OD2_INVALID_OBJECT
//
// MessageText:
//
//  Invalid object.
//
#define TLR_E_OD2_INVALID_OBJECT         ((TLR_RESULT)0xC0280007L)

//
// MessageId: TLR_E_OD2_INVALID_INDEX
//
// MessageText:
//
//  Invalid index. No such object.
//
#define TLR_E_OD2_INVALID_INDEX          ((TLR_RESULT)0xC0280008L)

//
// MessageId: TLR_E_OD2_SUBOBJECT_NOT_ALLOCATED
//
// MessageText:
//
//  Subobject is not allocated.
//
#define TLR_E_OD2_SUBOBJECT_NOT_ALLOCATED ((TLR_RESULT)0xC0280009L)

//
// MessageId: TLR_E_OD2_BUFFER_TOO_SMALL
//
// MessageText:
//
//  Buffer too small.
//
#define TLR_E_OD2_BUFFER_TOO_SMALL       ((TLR_RESULT)0xC028000AL)

//
// MessageId: TLR_E_OD2_READ_ONLY
//
// MessageText:
//
//  Read only object.
//
#define TLR_E_OD2_READ_ONLY              ((TLR_RESULT)0xC028000BL)

//
// MessageId: TLR_E_OD2_WRITE_ONLY
//
// MessageText:
//
//  Write only object.
//
#define TLR_E_OD2_WRITE_ONLY             ((TLR_RESULT)0xC028000CL)

//
// MessageId: TLR_E_OD2_SUBOBJECT_CNT_MISMATCH
//
// MessageText:
//
//  Subobject count mismatch.
//
#define TLR_E_OD2_SUBOBJECT_CNT_MISMATCH ((TLR_RESULT)0xC028000DL)

//
// MessageId: TLR_W_OD2_SUBOBJECT_IS_ADDRESSED_RELATIVE
//
// MessageText:
//
//  Subobject is addressed relative to a base ptr.
//
#define TLR_W_OD2_SUBOBJECT_IS_ADDRESSED_RELATIVE ((TLR_RESULT)0x8028000EL)

//
// MessageId: TLR_E_OD2_NOT_ENOUGH_MEMORY
//
// MessageText:
//
//  Not enough memory.
//
#define TLR_E_OD2_NOT_ENOUGH_MEMORY      ((TLR_RESULT)0xC028000FL)

//
// MessageId: TLR_E_OD2_CALLBACK_IS_LOCKED
//
// MessageText:
//
//  Callback is locked against changes.
//
#define TLR_E_OD2_CALLBACK_IS_LOCKED     ((TLR_RESULT)0xC0280010L)

//
// MessageId: TLR_E_OD2_DATATYPE_LENGTH_TOO_LONG
//
// MessageText:
//
//  Datatype length is too long.
//
#define TLR_E_OD2_DATATYPE_LENGTH_TOO_LONG ((TLR_RESULT)0xC0280011L)

//
// MessageId: TLR_E_OD2_PDO_LENGTH_WOULD_EXCEED
//
// MessageText:
//
//  PDO length would exceed maximum transfer size.
//
#define TLR_E_OD2_PDO_LENGTH_WOULD_EXCEED ((TLR_RESULT)0xC0280012L)

//
// MessageId: TLR_E_OD2_OBJECT_CANNOT_BE_PDO_MAPPED
//
// MessageText:
//
//  An object cannot be mapped in a PDO.
//
#define TLR_E_OD2_OBJECT_CANNOT_BE_PDO_MAPPED ((TLR_RESULT)0xC0280013L)

//
// MessageId: TLR_E_OD2_BUFFER_TOO_BIG
//
// MessageText:
//
//  Buffer too big.
//
#define TLR_E_OD2_BUFFER_TOO_BIG         ((TLR_RESULT)0xC0280014L)

//
// MessageId: TLR_E_OD2_UNSUPPORTED_ACCESS
//
// MessageText:
//
//  Unsupported Access.
//
#define TLR_E_OD2_UNSUPPORTED_ACCESS     ((TLR_RESULT)0xC0280015L)

//
// MessageId: TLR_E_OD2_VALUE_WRITTEN_TOO_HIGH
//
// MessageText:
//
//  Value written too high.
//
#define TLR_E_OD2_VALUE_WRITTEN_TOO_HIGH ((TLR_RESULT)0xC0280016L)

//
// MessageId: TLR_E_OD2_VALUE_WRITTEN_TOO_LOW
//
// MessageText:
//
//  Value written too low.
//
#define TLR_E_OD2_VALUE_WRITTEN_TOO_LOW  ((TLR_RESULT)0xC0280017L)

//
// MessageId: TLR_E_OD2_OBJECT_ALREADY_EXISTS
//
// MessageText:
//
//  Object already exists.
//
#define TLR_E_OD2_OBJECT_ALREADY_EXISTS  ((TLR_RESULT)0xC0280018L)

//
// MessageId: TLR_E_OD2_SUBOBJECT_ALREADY_EXISTS
//
// MessageText:
//
//  Sub-Object already exists.
//
#define TLR_E_OD2_SUBOBJECT_ALREADY_EXISTS ((TLR_RESULT)0xC0280019L)

//
// MessageId: TLR_E_OD2_SUBOBJECT_DOES_NOT_EXIST
//
// MessageText:
//
//  Sub-Object does not exist.
//
#define TLR_E_OD2_SUBOBJECT_DOES_NOT_EXIST ((TLR_RESULT)0xC028001AL)

//
// MessageId: TLR_E_OD2_OBJECT_CREATION_LOCKED
//
// MessageText:
//
//  Object creation locked.
//
#define TLR_E_OD2_OBJECT_CREATION_LOCKED ((TLR_RESULT)0xC028001BL)




#endif  //__OD2_ERROR_H

